
  /*
   *  Object %name    : main.c%
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the ECC parsing functions  
   *
   *  \version parser.c#1:csrc:1
   *  \author mottig
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/

#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "crysatptest_msg_defs.h"
#include "CRYS_SEP_ATP_Defines.h"
#include "DX_VOS_Mem.h"
#include "CRYS_SEP_ATP_ECC_Acceptance.h"

// temp
/*#include "gen_release.h"
#include "sep_hw_defs.h"
#include "cache_defs.h"*/


/************************ Defines ****************************/
/************************ Enums ******************************/
/************************ Typedefs ***************************/
/************************ Global Data ************************/
extern DxUint8_t   FailureFunctionNameOut[TST_FUNC_STRING_LEN];
/**************** Private function prototypes ****************/

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_ECC_ECDSA_NonIntegratedSignVerify

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* ECC cryptographic algorithms tests.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_ECC_ECDSA_NonIntegratedSignVerify(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t					SEP_Error = DX_SUCCESS;
	/* input data size in bytes: */
	DxUint16_t					SEP_DataInSize = 0; 
	/* input data size word aligned */
	DxUint32_t					SEP_MaxDataInSize; 
	/* public key size word aligned */
	DxUint32_t					SEP_MaxPublKeySizeInBytes;
	/* private key size word aligned */
	DxUint32_t					SEP_MaxPrivKeySizeInBytes;
	/* message length in words */
	DxUint32_t					SEP_MsgLengthInWords;

	DxUint32_t					SEP_KeyGenType;
	CRYS_ECPKI_DomainID_t		SEP_DomainID;
	DxUint8_t					*SEP_PublKeyIn_ptr;
	DxUint32_t					SEP_PublKeySizeInBytes;
	DxUint8_t					*SEP_PrivKeyIn_ptr;
	DxUint32_t					SEP_PrivKeySizeInBytes;
	CRYS_ECPKI_HASH_OpMode_t	SEP_HashMode;
	DxUint8_t					*SEP_DataIn_ptr;
	DxUint32_t					SEP_SignatureSize;

	/* 1. extract parameters from the message */
	/******************************************/
	SEP_DataInSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DATASIZE_IN_OFFSET];
	SEP_SignatureSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_SIGNATURESIZE_OFFSET];
	SEP_KeyGenType = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_KEYGENTYPE_OFFSET];
	SEP_DomainID = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DOMAINID_OFFSET];
	SEP_PublKeySizeInBytes = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_PUBLICKEYSIZE_OFFSET];
	SEP_PrivKeySizeInBytes = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_PRIVKEYSIZE_OFFSET];
	SEP_HashMode = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_HASH_OFFSET];

	SEP_MaxDataInSize = ((SEP_DataInSize + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPublKeySizeInBytes = ((SEP_PublKeySizeInBytes + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPrivKeySizeInBytes = ((SEP_PrivKeySizeInBytes + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_ECC_MSG_LENGTH_IN_WORDS + 
		SEP_MaxDataInSize/4 + SEP_MaxPublKeySizeInBytes/4 + SEP_MaxPrivKeySizeInBytes/4;

	SEP_DataIn_ptr  = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET];
	SEP_PublKeyIn_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET + SEP_MaxDataInSize/4];
	SEP_PrivKeyIn_ptr		 = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET + SEP_MaxDataInSize/4 + SEP_MaxPublKeySizeInBytes/4];

	/*DX_GEN_WriteRegister(0xA0180020, SEP_PublKeyIn_ptr[0]);
	DX_GEN_WriteRegister(0xA0180024, SEP_PublKeyIn_ptr[1]);
	DX_GEN_WriteRegister(0xA0180028, SEP_PublKeyIn_ptr[2]);
	DX_GEN_WriteRegister(0xA018002C, SEP_PublKeyIn_ptr[3]);
	DX_GEN_WriteRegister(0xA0180030, SEP_PublKeySizeInBytes);

	DX_SEP_FULL_CACHE_FLUSH();*/

	
	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_ECC_ECDSA_NonIntegratedSignVerify(
									SEP_KeyGenType,
									SEP_DomainID,
									SEP_PublKeyIn_ptr,
									SEP_PublKeySizeInBytes,
									SEP_PrivKeyIn_ptr,
									SEP_PrivKeySizeInBytes,
									SEP_HashMode,
									SEP_DataIn_ptr,
									SEP_DataInSize,
								    SEP_SignatureSize,
					                FailureFunctionNameOut);
	
	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_ECC_ECDSA_IntegratedSignVerify

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* ECC cryptographic algorithms tests.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_ECC_ECDSA_IntegratedSignVerify(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t					SEP_Error = DX_SUCCESS;
	/* input data size in bytes: */
	DxUint16_t					SEP_DataInSize = 0; 
	/* input data size word aligned */
	DxUint32_t					SEP_MaxDataInSize; 
	/* public key size word aligned */
	DxUint32_t					SEP_MaxPublKeySizeInBytes;
	/* private key size word aligned */
	DxUint32_t					SEP_MaxPrivKeySizeInBytes;
	/* message length in words */
	DxUint32_t					SEP_MsgLengthInWords;

	DxUint32_t					SEP_KeyGenType;
	CRYS_ECPKI_DomainID_t		SEP_DomainID;
	DxUint8_t					*SEP_PublKeyIn_ptr;
	DxUint32_t					SEP_PublKeySizeInBytes;
	DxUint8_t					*SEP_PrivKeyIn_ptr;
	DxUint32_t					SEP_PrivKeySizeInBytes;
	CRYS_ECPKI_HASH_OpMode_t	SEP_HashMode;
	DxUint8_t					*SEP_DataIn_ptr;
	DxUint32_t					SEP_SignatureSize;

	/* 1. extract parameters from the message */
	/******************************************/
	SEP_DataInSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DATASIZE_IN_OFFSET];
	SEP_SignatureSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_SIGNATURESIZE_OFFSET];
	SEP_KeyGenType = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_KEYGENTYPE_OFFSET];
	SEP_DomainID = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DOMAINID_OFFSET];
	SEP_PublKeySizeInBytes = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_PUBLICKEYSIZE_OFFSET];
	SEP_PrivKeySizeInBytes = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_PRIVKEYSIZE_OFFSET];
	SEP_HashMode = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_HASH_OFFSET];

	SEP_MaxDataInSize = ((SEP_DataInSize + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPublKeySizeInBytes = ((SEP_PublKeySizeInBytes + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPrivKeySizeInBytes = ((SEP_PrivKeySizeInBytes + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_ECC_MSG_LENGTH_IN_WORDS + 
		SEP_MaxDataInSize/4 + SEP_MaxPublKeySizeInBytes/4 + SEP_MaxPrivKeySizeInBytes/4;

	SEP_DataIn_ptr  = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET];
	SEP_PublKeyIn_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET + SEP_MaxDataInSize/4];
	SEP_PrivKeyIn_ptr		 = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET + SEP_MaxDataInSize/4 + SEP_MaxPublKeySizeInBytes/4];

	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_ECC_ECDSA_IntegratedSignVerify(
		SEP_KeyGenType,
		SEP_DomainID,
		SEP_PublKeyIn_ptr,
		SEP_PublKeySizeInBytes,
		SEP_PrivKeyIn_ptr,
		SEP_PrivKeySizeInBytes,
		SEP_HashMode,
		SEP_DataIn_ptr,
		SEP_DataInSize,
		SEP_SignatureSize,
		FailureFunctionNameOut);

	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_ECC_DH

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* ECC cryptographic algorithms tests.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_ECC_DH(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t					SEP_Error = DX_SUCCESS;
	/* public key size word aligned */
	DxUint32_t					SEP_MaxPublKeySizeInBytes1;
	DxUint32_t					SEP_MaxPublKeySizeInBytes2;
	/* private key size word aligned */
	DxUint32_t					SEP_MaxPrivKeySizeInBytes1;
	DxUint32_t					SEP_MaxPrivKeySizeInBytes2;
	/* message length in words */
	DxUint32_t					SEP_MsgLengthInWords;

	DxUint32_t					SEP_KeyGenType;
	CRYS_ECPKI_DomainID_t		SEP_DomainID;
	DxUint8_t			       *SEP_PublKeyIn1_ptr;
	DxUint32_t					SEP_PublKeySizeInBytes1;
	DxUint8_t				   *SEP_PublKeyIn2_ptr;
	DxUint32_t					SEP_PublKeySizeInBytes2;
	DxUint8_t				   *SEP_PrivKeyIn1_ptr;
	DxUint32_t					SEP_PrivKeySizeInBytes1;
	DxUint8_t				   *SEP_PrivKeyIn2_ptr;
	DxUint32_t					SEP_PrivKeySizeInBytes2;
	DxUint32_t					SEP_MaxSecretKeySize;

	/* 1. extract parameters from the message */
	/******************************************/
	SEP_KeyGenType = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DH_KEYGENTYPE_OFFSET];
	SEP_DomainID = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DH_DOMAINID_OFFSET];
	SEP_PublKeySizeInBytes1 = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DH_PUBLICKEYSIZE1_OFFSET];
	SEP_PrivKeySizeInBytes1 = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DH_PRIVKEYSIZE1_OFFSET];
	SEP_PublKeySizeInBytes2 = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DH_PUBLICKEYSIZE2_OFFSET];
	SEP_PrivKeySizeInBytes2 = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DH_PRIVKEYSIZE2_OFFSET];
	SEP_MaxSecretKeySize = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DH_MaxSecretKeySize_OFFSET];

	SEP_MaxPublKeySizeInBytes1 = ((SEP_PublKeySizeInBytes1 + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPublKeySizeInBytes2 = ((SEP_PublKeySizeInBytes2 + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPrivKeySizeInBytes1 = ((SEP_PrivKeySizeInBytes1 + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPrivKeySizeInBytes2 = ((SEP_PrivKeySizeInBytes2 + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_ECC_DH_MSG_LENGTH_IN_WORDS + 
		SEP_MaxPublKeySizeInBytes1/4 + SEP_MaxPrivKeySizeInBytes1/4 +
		SEP_MaxPublKeySizeInBytes2/4 + SEP_MaxPrivKeySizeInBytes2/4;

	SEP_PublKeyIn1_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DH_PublKey1_OFFSET];
	SEP_PrivKeyIn1_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DH_PublKey1_OFFSET + SEP_MaxPublKeySizeInBytes1/4];
	SEP_PublKeyIn2_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DH_PublKey1_OFFSET + SEP_MaxPublKeySizeInBytes1/4 + SEP_MaxPrivKeySizeInBytes1/4];
	SEP_PrivKeyIn2_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DH_PublKey1_OFFSET + SEP_MaxPublKeySizeInBytes1/4 
		                                     + SEP_MaxPrivKeySizeInBytes1/4 + SEP_MaxPublKeySizeInBytes2/4];

	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_ECC_DH(
							SEP_KeyGenType,
							SEP_DomainID,
							SEP_PublKeyIn1_ptr,
							SEP_PublKeySizeInBytes1,
							SEP_PublKeyIn2_ptr,
							SEP_PublKeySizeInBytes2,
							SEP_PrivKeyIn1_ptr,
							SEP_PrivKeySizeInBytes1,
							SEP_PrivKeyIn2_ptr,
							SEP_PrivKeySizeInBytes2,
							SEP_MaxSecretKeySize,
							FailureFunctionNameOut);
		
	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_ECC_ElGamal_EncDec

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* ECC cryptographic algorithms tests.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_ECC_ElGamal_EncDec(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t					SEP_Error = DX_SUCCESS;
	/* input data size in bytes: */
	DxUint16_t					SEP_DataInSize = 0; 
	/* input data size word aligned */
	DxUint32_t					SEP_MaxDataInSize; 
	/* public key size word aligned */
	DxUint32_t					SEP_MaxPublKeySizeInBytes;
	/* private key size word aligned */
	DxUint32_t					SEP_MaxPrivKeySizeInBytes;
	/* message length in words */
	DxUint32_t					SEP_MsgLengthInWords;

	DxUint32_t					SEP_KeyGenType;
	CRYS_ECPKI_DomainID_t		SEP_DomainID;
	DxUint8_t					*SEP_PublKeyIn_ptr;
	DxUint32_t					SEP_PublKeySizeInBytes;
	DxUint8_t					*SEP_PrivKeyIn_ptr;
	DxUint32_t					SEP_PrivKeySizeInBytes;
	DxUint8_t					*SEP_DataIn_ptr;
	DxUint32_t                  SEP_EncryptedMsgSize;

	/* 1. extract parameters from the message */
	/******************************************/
	SEP_DataInSize       = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DATASIZE_IN_OFFSET];
	SEP_EncryptedMsgSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_SIGNATURESIZE_OFFSET];
	SEP_KeyGenType       = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_KEYGENTYPE_OFFSET];
	SEP_DomainID         = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DOMAINID_OFFSET];
	SEP_PublKeySizeInBytes = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_PUBLICKEYSIZE_OFFSET];
	SEP_PrivKeySizeInBytes = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_PRIVKEYSIZE_OFFSET];
	

	SEP_MaxDataInSize = ((SEP_DataInSize + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPublKeySizeInBytes = ((SEP_PublKeySizeInBytes + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPrivKeySizeInBytes = ((SEP_PrivKeySizeInBytes + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_ECC_MSG_LENGTH_IN_WORDS + 
		SEP_MaxDataInSize/4 + SEP_MaxPublKeySizeInBytes/4 + SEP_MaxPrivKeySizeInBytes/4;

	SEP_DataIn_ptr    = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET];
	SEP_PublKeyIn_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET + SEP_MaxDataInSize/4];
	SEP_PrivKeyIn_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET + SEP_MaxDataInSize/4 + SEP_MaxPublKeySizeInBytes/4];

	/*DX_GEN_WriteRegister(0xA0180020, SEP_PublKeyIn_ptr[0]);
	DX_GEN_WriteRegister(0xA0180024, SEP_PublKeyIn_ptr[1]);
	DX_GEN_WriteRegister(0xA0180028, SEP_PublKeyIn_ptr[2]);
	DX_GEN_WriteRegister(0xA018002C, SEP_PublKeyIn_ptr[3]);
	DX_GEN_WriteRegister(0xA0180030, SEP_PublKeySizeInBytes);

	DX_SEP_FULL_CACHE_FLUSH();*/

	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_ECC_ElGamal_EncDec(
		SEP_KeyGenType,
		SEP_DomainID,
		SEP_PublKeyIn_ptr,
		SEP_PublKeySizeInBytes,
		SEP_PrivKeyIn_ptr,
		SEP_PrivKeySizeInBytes,
		SEP_DataIn_ptr,
		SEP_DataInSize,
		SEP_EncryptedMsgSize,
		FailureFunctionNameOut);

	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_ECC_ImportExportKeyPair

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* ECC cryptographic algorithms tests.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_ECC_ImportExportKeyPair(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t					SEP_Error = DX_SUCCESS;
	/* input data size in bytes: */
	DxUint16_t					SEP_DataInSize = 0; 
	/* input data size word aligned */
	DxUint32_t					SEP_MaxDataInSize; 
	/* public key size word aligned */
	DxUint32_t					SEP_MaxPublKeySizeInBytes;
	/* private key size word aligned */
	DxUint32_t					SEP_MaxPrivKeySizeInBytes;
	/* message length in words */
	DxUint32_t					SEP_MsgLengthInWords;

	DxUint32_t					SEP_KeyGenType;
	CRYS_ECPKI_DomainID_t		SEP_DomainID;
	DxUint8_t					*SEP_PublKeyIn_ptr;
	DxUint32_t					SEP_PublKeySizeInBytes;
	DxUint8_t					*SEP_PrivKeyIn_ptr;
	DxUint32_t					SEP_PrivKeySizeInBytes;
	CRYS_ECPKI_HASH_OpMode_t	SEP_HashMode;
	DxUint8_t					*SEP_DataIn_ptr;
	DxUint32_t					SEP_SignatureSize;

	/* 1. extract parameters from the message */
	/******************************************/
	SEP_DataInSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DATASIZE_IN_OFFSET];
	SEP_SignatureSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_SIGNATURESIZE_OFFSET];
	SEP_KeyGenType = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_KEYGENTYPE_OFFSET];
	SEP_DomainID = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_DOMAINID_OFFSET];
	SEP_PublKeySizeInBytes = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_PUBLICKEYSIZE_OFFSET];
	SEP_PrivKeySizeInBytes = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_PRIVKEYSIZE_OFFSET];
	SEP_HashMode = (DxUint16_t)msg[DX_EXT_SEP_HOST_ECC_HASH_OFFSET];

	SEP_MaxDataInSize = ((SEP_DataInSize + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPublKeySizeInBytes = ((SEP_PublKeySizeInBytes + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);
	SEP_MaxPrivKeySizeInBytes = ((SEP_PrivKeySizeInBytes + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_ECC_MSG_LENGTH_IN_WORDS + 
		SEP_MaxDataInSize/4 + SEP_MaxPublKeySizeInBytes/4 + SEP_MaxPrivKeySizeInBytes/4;

	SEP_DataIn_ptr  = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET];
	SEP_PublKeyIn_ptr = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET + SEP_MaxDataInSize/4];
	SEP_PrivKeyIn_ptr		 = 	(DxUint8_t*)&msg[DX_EXT_SEP_HOST_ECC_DataIn_OFFSET + SEP_MaxDataInSize/4 + SEP_MaxPublKeySizeInBytes/4];

	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_ECC_ImportExportKeyPair(
		SEP_KeyGenType,
		SEP_DomainID,
		SEP_PublKeyIn_ptr,
		SEP_PublKeySizeInBytes,
		SEP_PrivKeyIn_ptr,
		SEP_PrivKeySizeInBytes,
		SEP_HashMode,
		SEP_DataIn_ptr,
		SEP_DataInSize,
		SEP_SignatureSize,
		FailureFunctionNameOut);

	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}
